/// <reference types="node" />
import * as net from "net";
import { PromiseDuplex } from "promise-duplex";
export { TimeoutError } from "./timeout-error";
export declare class PromiseSocket<TSocket extends net.Socket> extends PromiseDuplex<TSocket> {
    readonly socket: TSocket;
    private timeoutHandler?;
    constructor(socket?: TSocket);
    connect(port: number, host?: string): Promise<void>;
    connect(path: string): Promise<void>;
    connect(options: net.SocketConnectOpts): Promise<void>;
    setTimeout(timeout: number): void;
}
export default PromiseSocket;
