/// <reference types="node" />
import "core-js/modules/es.symbol.async-iterator";
interface ReadableStream extends NodeJS.ReadableStream {
    closed?: boolean;
    destroyed?: boolean;
    destroy?(): void;
}
export declare class PromiseReadable<TReadable extends ReadableStream> implements AsyncIterable<Buffer | string> {
    readonly stream: TReadable;
    readonly _isPromiseReadable: boolean;
    _errored?: Error;
    constructor(stream: TReadable);
    static [Symbol.hasInstance](instance: any): boolean;
    read(size?: number): Promise<Buffer | string | undefined>;
    readAll(): Promise<Buffer | string | undefined>;
    setEncoding(encoding: BufferEncoding): this;
    once(event: "close" | "end" | "error"): Promise<void>;
    once(event: "open"): Promise<number>;
    iterate(size?: number): AsyncIterableIterator<Buffer | string>;
    [Symbol.asyncIterator](): AsyncIterableIterator<Buffer | string>;
    destroy(): void;
    private readonly errorHandler;
}
export default PromiseReadable;
