'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _readline = require('readline');

var _readline2 = _interopRequireDefault(_readline);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
                                                                                                                                                           * Readline Promise
                                                                                                                                                           *
                                                                                                                                                           * @author Branden Horiuchi <bhoriuchi@gmail.com>
                                                                                                                                                           * @license MIT
                                                                                                                                                           * @description Provides a drop-in replacement for
                                                                                                                                                           * readline with additional Promise based functions.
                                                                                                                                                           * uses an async iterator to iterate through the lines
                                                                                                                                                           * as they are read
                                                                                                                                                           *
                                                                                                                                                           */


/**
 * Credits
 * https://github.com/graphql/graphql-js/blob/master
 * /src/subscription/__tests__/eventEmitterAsyncIterator.js
 * https://github.com/leebyron/iterall/
 */
var SYMBOL_ASYNC_ITERATOR = typeof Symbol === 'function' && Symbol.asyncIterator;
var $$asyncIterator = SYMBOL_ASYNC_ITERATOR || '@@asyncIterator';

var AsyncIteratorBacking = function () {
  function AsyncIteratorBacking(values) {
    var _this2 = this;

    _classCallCheck(this, AsyncIteratorBacking);

    this.done = false;
    this.dataQueue = Array.isArray(values) ? values.slice() : [];
    this.awaitQueue = [];

    if (Array.isArray(values)) {
      values.length = 0;
      values.push = function (value) {
        return _this2._push(value);
      };
    }
  }

  AsyncIteratorBacking.prototype.iterator = function iterator() {
    var _this = this;
    var iterator = {
      next() {
        return _this.done && !_this.dataQueue.length ? iterator.return() : _this._next();
      },
      return() {
        _this._end();
        return Promise.resolve({ value: undefined, done: true });
      },
      throw(error) {
        _this._end();
        return Promise.reject(error);
      },
      [$$asyncIterator]() {
        return iterator;
      }
    };
    return iterator;
  };

  AsyncIteratorBacking.prototype._push = function _push(value) {
    return this._pushValue(value);
  };

  AsyncIteratorBacking.prototype._pushValue = function _pushValue(value) {
    return this.awaitQueue.length ? this.awaitQueue.shift()({ value, done: false }) : this.dataQueue.push(value);
  };

  AsyncIteratorBacking.prototype._next = function _next() {
    var _this3 = this;

    return new Promise(function (resolve) {
      if (_this3.dataQueue.length) {
        return resolve({
          value: _this3.dataQueue.shift(),
          done: false
        });
      } else if (_this3.done) {
        return resolve({
          value: undefined,
          done: true
        });
      }
      _this3.awaitQueue.push(resolve);
    });
  };

  AsyncIteratorBacking.prototype._end = function _end() {
    if (!this.done) {
      this.done = true;
      this.awaitQueue.forEach(function (resolve) {
        resolve({ value: undefined, done: true });
      });
      this.awaitQueue.length = 0;
      this.dataQueue.length = 0;
    }
  };

  return AsyncIteratorBacking;
}();

var AsyncIterator = function AsyncIterator() {
  _classCallCheck(this, AsyncIterator);

  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return new (Function.prototype.bind.apply(AsyncIteratorBacking, [null].concat(args)))().iterator();
};

AsyncIterator.fromStream = function (stream, options) {
  var array = [];
  var opts = Object.assign({}, options);
  var DATA = opts.dataEvent || 'data';
  var CLOSE = opts.closeEvent || 'close';
  var backing = new AsyncIteratorBacking(array, opts);
  stream.on(DATA, function (value) {
    return array.push(value);
  });
  stream.on(CLOSE, function () {
    backing.done = true;
  });
  return backing.iterator();
};

/**
 * Extends the readline Interface class with additional methods
 * that use native Promise objects to perform async operations
 */

var Interface = function (_readline$Interface) {
  _inherits(Interface, _readline$Interface);

  function Interface(input, output, completer, terminal) {
    _classCallCheck(this, Interface);

    return _possibleConstructorReturn(this, _readline$Interface.call(this, input, output, completer, terminal));
  }

  /**
   * Alias for forEach (backward compatibility)
   * @param {*} iteratee
   */


  Interface.prototype.each = function each(iteratee) {
    return this.forEach(iteratee);
  };

  /**
   * Iterates over each line and invokes the iteratee
   * @param {*} iteratee
   */


  Interface.prototype.forEach = function forEach(iteratee) {
    return this.reduce(function (accum, current, index, lines) {
      iteratee(current, index, lines);
      return accum;
    });
  };

  /**
   * performs a map operation on the lines
   * @param {*} iteratee
   */


  Interface.prototype.map = function map(iteratee) {
    return this.reduce(function (accum, current, index, lines) {
      accum.push(iteratee(current, index, lines));
      return accum;
    }, []);
  };

  /**
   * Performs a reduce operation on the lines
   * @param {*} iteratee
   * @param {*} accumulator
   */


  Interface.prototype.reduce = function reduce(iteratee, accumulator) {
    if (typeof iteratee !== 'function') {
      throw new Error('iteratee should be a function');
    }
    var values = [];
    var iterator = AsyncIterator.fromStream(this, {
      dataEvent: 'line'
    });

    return Promise.resolve(accumulator).then(function (resolvedAccumulator) {
      var accum = resolvedAccumulator;
      var reducer = function reducer() {
        return iterator.next().then(function (_ref) {
          var value = _ref.value,
              done = _ref.done;

          if (!done) {
            var index = values.length;
            values.push(value);
            accum = iteratee(accum, value, index, values);
            return reducer();
          }
          return accum;
        });
      };
      return reducer();
    });
  };

  /**
   * Asks a question returns a promise
   * @param {*} query
   */


  Interface.prototype.questionAsync = function questionAsync(query) {
    var _this5 = this;

    return new Promise(function (resolve) {
      _this5.question(query, resolve);
    });
  };

  return Interface;
}(_readline2.default.Interface);

/**
 * Export an extended readline instance so
 * that it can be used as a drop in replacement
 */


exports.default = Object.assign({}, _readline2.default, {
  Interface,
  createInterface() {
    for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return new (Function.prototype.bind.apply(Interface, [null].concat(args)))();
  }
});