/// <reference types="node" />
interface WritableStream extends NodeJS.WritableStream {
    bytesWritten?: number;
    closed?: boolean;
    destroyed?: boolean;
    cork?(): void;
    uncork?(): void;
    destroy?(): void;
}
export declare class PromiseWritable<TWritable extends WritableStream> {
    readonly stream: TWritable;
    readonly _isPromiseWritable: boolean;
    _errored?: Error;
    constructor(stream: TWritable);
    static [Symbol.hasInstance](instance: PromiseWritable<WritableStream>): boolean;
    write(chunk: string | Buffer, encoding?: BufferEncoding): Promise<number>;
    writeAll(content: string | Buffer, chunkSize?: number): Promise<number>;
    once(event: "close" | "error" | "finish"): Promise<void>;
    once(event: "open"): Promise<number>;
    once(event: "pipe" | "unpipe"): Promise<NodeJS.ReadableStream>;
    end(): Promise<void>;
    destroy(): void;
    private errorHandler;
}
export default PromiseWritable;
