"use strict";
/// <reference types="node" />
Object.defineProperty(exports, "__esModule", { value: true });
exports.PromiseDuplex = void 0;
require("core-js/modules/es.symbol.async-iterator");
const promise_readable_1 = require("promise-readable");
const promise_writable_1 = require("promise-writable");
class PromiseDuplex extends promise_readable_1.PromiseReadable {
    constructor(stream) {
        super(stream);
        this.stream = stream;
        this.isPromiseReadable = true;
        this.isPromiseWritable = true;
        this.readable = new promise_readable_1.PromiseReadable(stream);
        this.writable = new promise_writable_1.PromiseWritable(stream);
    }
    // PromiseReadable
    read(size) {
        return this.readable.read(size);
    }
    readAll() {
        return this.readable.readAll();
    }
    setEncoding(encoding) {
        this.readable.setEncoding(encoding);
        return this;
    }
    iterate(size) {
        return this.readable.iterate(size);
    }
    [Symbol.asyncIterator]() {
        return this.readable[Symbol.asyncIterator]();
    }
    // PromiseWritable
    write(chunk, encoding) {
        return this.writable.write(chunk, encoding);
    }
    writeAll(content, chunkSize) {
        return this.writable.writeAll(content, chunkSize);
    }
    end() {
        return this.writable.end();
    }
    once(event) {
        const stream = this.stream;
        return new Promise((resolve, reject) => {
            if (this.readable._errored) {
                const err = this.readable._errored;
                this.readable._errored = undefined;
                return reject(err);
            }
            if (this.writable._errored) {
                const err = this.writable._errored;
                this.writable._errored = undefined;
                return reject(err);
            }
            if (stream.closed) {
                if (event === "close") {
                    return resolve();
                }
                else {
                    return reject(new Error(`once ${event} after close`));
                }
            }
            if (stream.destroyed) {
                if (event === "close" || event === "end" || event === "finish") {
                    return resolve();
                }
                else {
                    return reject(new Error(`once ${event} after destroy`));
                }
            }
            const eventHandler = event !== "end" && event !== "finish" && event !== "error"
                ? (argument) => {
                    removeListeners();
                    resolve(argument);
                }
                : undefined;
            const closeHandler = () => {
                removeListeners();
                resolve();
            };
            const endHandler = event !== "close"
                ? () => {
                    removeListeners();
                    resolve();
                }
                : undefined;
            const errorHandler = (err) => {
                this.readable._errored = undefined;
                this.writable._errored = undefined;
                removeListeners();
                reject(err);
            };
            const finishHandler = event !== "close"
                ? () => {
                    removeListeners();
                    resolve();
                }
                : undefined;
            const removeListeners = () => {
                if (eventHandler) {
                    stream.removeListener(event, eventHandler);
                }
                stream.removeListener("close", closeHandler);
                if (endHandler) {
                    stream.removeListener("end", endHandler);
                }
                stream.removeListener("error", errorHandler);
                if (finishHandler) {
                    stream.removeListener("finish", finishHandler);
                }
            };
            if (eventHandler) {
                stream.on(event, eventHandler);
            }
            stream.on("close", closeHandler);
            if (endHandler) {
                stream.on("end", endHandler);
            }
            if (finishHandler) {
                stream.on("finish", finishHandler);
            }
            stream.on("error", errorHandler);
        });
    }
    destroy() {
        if (this.readable) {
            this.readable.destroy();
        }
        if (this.writable) {
            this.writable.destroy();
        }
    }
}
exports.PromiseDuplex = PromiseDuplex;
exports.default = PromiseDuplex;
//# sourceMappingURL=promise-duplex.js.map