"use strict";
/// <reference types="node" />
Object.defineProperty(exports, "__esModule", { value: true });
exports.PromiseSocket = void 0;
const tslib_1 = require("tslib");
const net = tslib_1.__importStar(require("net"));
const promise_duplex_1 = require("promise-duplex");
const timeout_error_1 = require("./timeout-error");
var timeout_error_2 = require("./timeout-error");
Object.defineProperty(exports, "TimeoutError", { enumerable: true, get: function () { return timeout_error_2.TimeoutError; } });
class PromiseSocket extends promise_duplex_1.PromiseDuplex {
    constructor(socket = new net.Socket()) {
        super(socket);
        this.socket = socket;
    }
    connect(arg1, arg2) {
        const socket = this.stream;
        return new Promise((resolve, reject) => {
            if (this.readable._errored) {
                const err = this.readable._errored;
                this.readable._errored = undefined;
                reject(err);
            }
            if (this.writable._errored) {
                const err = this.writable._errored;
                this.writable._errored = undefined;
                reject(err);
            }
            const connectHandler = () => {
                socket.removeListener("error", errorHandler);
                resolve();
            };
            const errorHandler = (err) => {
                this.readable._errored = undefined;
                this.writable._errored = undefined;
                socket.removeListener("connect", connectHandler);
                reject(err);
            };
            socket.once("error", errorHandler);
            if (arg2 !== undefined) {
                socket.connect(arg1, arg2, connectHandler);
            }
            else {
                socket.connect(arg1, connectHandler);
            }
        });
    }
    setTimeout(timeout) {
        const socket = this.stream;
        if (timeout === 0) {
            if (this.timeoutHandler) {
                socket.removeListener("timeout", this.timeoutHandler);
                this.timeoutHandler = undefined;
            }
        }
        else {
            if (!this.timeoutHandler) {
                this.timeoutHandler = () => {
                    this.timeoutHandler = undefined;
                    socket.destroy(new timeout_error_1.TimeoutError());
                };
                socket.once("timeout", this.timeoutHandler);
            }
        }
        socket.setTimeout(timeout);
    }
}
exports.PromiseSocket = PromiseSocket;
exports.default = PromiseSocket;
//# sourceMappingURL=promise-socket.js.map