/// <reference types="node" />
import "core-js/modules/es.symbol.async-iterator";
import { Duplex } from "stream";
import { PromiseReadable } from "promise-readable";
import { PromiseWritable } from "promise-writable";
interface DuplexStream extends Duplex {
    closed?: boolean;
}
export declare class PromiseDuplex<TDuplex extends DuplexStream> extends PromiseReadable<TDuplex> implements AsyncIterable<Buffer | string> {
    readonly stream: TDuplex;
    readonly readable: PromiseReadable<TDuplex>;
    readonly writable: PromiseWritable<TDuplex>;
    readonly isPromiseReadable: boolean;
    readonly isPromiseWritable: boolean;
    constructor(stream: TDuplex);
    read(size?: number): Promise<string | Buffer | undefined>;
    readAll(): Promise<string | Buffer | undefined>;
    setEncoding(encoding: BufferEncoding): this;
    iterate(size?: number): AsyncIterableIterator<Buffer | string>;
    [Symbol.asyncIterator](): AsyncIterableIterator<Buffer | string>;
    write(chunk: string | Buffer, encoding?: BufferEncoding): Promise<number>;
    writeAll(content: string | Buffer, chunkSize?: number): Promise<number>;
    end(): Promise<void>;
    once(event: "close" | "end" | "error" | "finish"): Promise<void>;
    once(event: "open"): Promise<number>;
    once(event: "pipe" | "unpipe"): Promise<NodeJS.ReadableStream>;
    destroy(): void;
}
export default PromiseDuplex;
